/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit.projects;

import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.types.AsEditPVersion1;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.types.AsEditPVersion2;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.types.IProjectVersion;
import java.util.Arrays;
import java.util.Optional;

public enum EnumProjectVersion {
    JSON_VERSION("json", "Json", new AsEditPVersion1()),
    LINE_VERSION("v1", "Line", new AsEditPVersion2());

    public static final EnumProjectVersion NEWEST;
    private String extension;
    private String nickName;
    private IProjectVersion projectVersion;

    private EnumProjectVersion(String extension, String nickName, IProjectVersion projectVersion) {
        this.extension = extension;
        this.projectVersion = projectVersion;
        this.nickName = nickName;
    }

    public static Optional<EnumProjectVersion> getFromExtension(String extension) {
        return Arrays.stream(EnumProjectVersion.values()).filter(i -> i.getExtension().equalsIgnoreCase(extension)).findAny();
    }

    public boolean isOutdated() {
        return !this.equals((Object)NEWEST);
    }

    public String getExtension() {
        return this.extension;
    }

    public IProjectVersion getLoader() {
        return this.projectVersion;
    }

    public String getNickName() {
        return this.nickName;
    }

    static {
        NEWEST = LINE_VERSION;
    }
}

