/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit.projects.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.whiletrue.toolsmod.module.defined.tools.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.AsEditProject;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.EnumProjectVersion;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.types.IProjectVersion;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public class AsEditPVersion2
implements IProjectVersion {
    @Override
    public Optional<AsEditProject> loadProperties(File file) {
        Optional<String[]> optLines = FileUtil.getInstance().readLines(file.getAbsolutePath(), 3);
        if (!optLines.isPresent()) {
            return Optional.empty();
        }
        String[] lines = optLines.get();
        return Optional.of(new AsEditProject(file, lines[0], lines[1], lines[2], EnumProjectVersion.LINE_VERSION));
    }

    @Override
    public Optional<EditableArmorStand[]> loadProject(File file, BlockPos pos) {
        try {
            String cont = FileUtil.getInstance().loadFile(file.getAbsolutePath()).get();
            int y = 0;
            for (int i2 = 0; i2 < 3; ++i2) {
                y = cont.indexOf(10, y + 1);
            }
            JsonArray arr = new JsonParser().parse(cont.substring(y + 1)).getAsJsonArray();
            return Optional.of(StreamSupport.stream(arr.spliterator(), false).map(i -> {
                JsonObject obj = i.getAsJsonObject();
                EditableArmorStand as = new EditableArmorStand(0.0, 0.0, 0.0);
                CompoundNBT nbt = ItemUtil.getInstance().stringToNbt(obj.get("nbt").getAsString()).get();
                as.func_70020_e(nbt);
                as.setReferenceName(obj.get("name").getAsString());
                ListNBT realtive = nbt.func_150295_c("Pos", 6);
                as.func_70107_b((double)pos.func_177958_n() + realtive.func_150309_d(0), (double)pos.func_177956_o() + realtive.func_150309_d(1), (double)pos.func_177952_p() + realtive.func_150309_d(2));
                return as;
            }).toArray(EditableArmorStand[]::new));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean saveProject(AsEditProject project, EditableArmorStand[] stands, File file, BlockPos relative) {
        String outPut = String.format("%s\n%s\n%s\n", project.getName(-1), project.getAuthor(-1), project.getVersion(-1));
        JsonArray out = new JsonArray();
        Arrays.stream(stands).forEach(i -> {
            JsonObject wrapper = new JsonObject();
            CompoundNBT nbt = ItemUtil.getInstance().getTagFromArmorstand((ArmorStandEntity)i);
            ListNBT posList = new ListNBT();
            posList.add((Object)DoubleNBT.func_229684_a_((double)(i.func_226277_ct_() - (double)relative.func_177958_n())));
            posList.add((Object)DoubleNBT.func_229684_a_((double)(i.func_226278_cu_() - (double)relative.func_177956_o())));
            posList.add((Object)DoubleNBT.func_229684_a_((double)(i.func_226281_cx_() - (double)relative.func_177952_p())));
            nbt.func_218657_a("Pos", (INBT)posList);
            wrapper.addProperty("name", i.getReferenceName());
            wrapper.addProperty("nbt", nbt.toString());
            out.add((JsonElement)wrapper);
        });
        outPut = outPut + out.toString();
        FileUtil.getInstance().printToFile(file.getAbsolutePath(), outPut);
        return true;
    }
}

