/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.visual;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.settings.defined.SettingBool;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ModuleShulkerView
extends Module {
    private ResourceLocation widget_location = new ResourceLocation("textures/gui/container/shulker_box.png");
    private SettingBool sColor = (SettingBool)((Setting)new SettingBool().name("renderColor")).standard(true);
    private SettingBool sRenderEmpty = (SettingBool)((Setting)new SettingBool().name("renderEmpty")).standard(false);
    private ItemStack lastShulker;
    private NonNullList<ItemStack> shulkerItems = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private float[] shulkerColor = new float[3];

    public ModuleShulkerView() {
        super("ShulkerView", ModuleCategory.VISUALS, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    void onRenderTooltip(RenderTooltipEvent.PostBackground evt) {
        if (!this.isActive()) {
            return;
        }
        this.updateHovered(evt.getStack());
        if (this.lastShulker == null) {
            return;
        }
        int guiSize = 71;
        int x = evt.getX() - 5;
        int y = evt.getY() + evt.getHeight() + guiSize > this.mc.field_71462_r.field_230709_l_ ? evt.getY() - guiSize : evt.getY() + evt.getHeight() + 4;
        this.renderBackground(evt.getMatrixStack(), x, y);
        this.renderItems(x, y);
    }

    private void updateHovered(ItemStack stack) {
        if (stack.equals(this.lastShulker)) {
            return;
        }
        this.lastShulker = null;
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return;
        }
        BlockItem itm = (BlockItem)stack.func_77973_b();
        if (!(itm.func_179223_d() instanceof ShulkerBoxBlock)) {
            return;
        }
        if (!(((Boolean)this.sRenderEmpty.value).booleanValue() || stack.func_77942_o() && !stack.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Items", 10).isEmpty())) {
            return;
        }
        DyeColor dye = ((ShulkerBoxBlock)itm.func_179223_d()).func_190956_e();
        int color = (dye == null ? DyeColor.PURPLE : dye).getColorValue();
        this.shulkerColor[0] = (float)((color & 0xFF0000) >> 16) / 255.0f;
        this.shulkerColor[1] = (float)((color & 0xFF00) >> 8) / 255.0f;
        this.shulkerColor[2] = (float)(color & 0xFF) / 255.0f;
        this.lastShulker = stack;
        this.shulkerItems.clear();
        if (stack.func_77942_o()) {
            ItemStackHelper.func_191283_b((CompoundNBT)stack.func_77978_p().func_74775_l("BlockEntityTag"), this.shulkerItems);
        }
    }

    private void renderItems(int x, int y) {
        this.mc.func_175599_af().field_77023_b = 300.0f;
        for (int i = 0; i < this.shulkerItems.size(); ++i) {
            ItemStack itm = (ItemStack)this.shulkerItems.get(i);
            int itmX = x + i % 9 * 18 + 8;
            int itmY = y + i / 9 * 18 + 8;
            this.mc.func_175599_af().func_180450_b(itm, itmX, itmY);
            this.mc.func_175599_af().func_175030_a(this.mc.field_71466_p, itm, itmX, itmY);
        }
    }

    private void renderBackground(MatrixStack ms, int x, int y) {
        RenderSystem.disableDepthTest();
        this.mc.field_71446_o.func_110577_a(this.widget_location);
        if (((Boolean)this.sColor.value).booleanValue()) {
            GL11.glColor3f((float)this.shulkerColor[0], (float)this.shulkerColor[1], (float)this.shulkerColor[2]);
        }
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)x, (int)y, (int)-90, (float)0.0f, (float)0.0f, (int)176, (int)5, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)x, (int)(y + 5), (int)-90, (float)0.0f, (float)15.0f, (int)176, (int)56, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)x, (int)(y + 5 + 54 + 2), (int)-90, (float)0.0f, (float)160.0f, (int)176, (int)6, (int)256, (int)256);
    }
}

