/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.settings.defined;

import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.settings.views.SettingView;
import de.whiletrue.toolsmod.settings.views.SettingViewIntegerSlider;
import de.whiletrue.toolsmod.settings.views.SettingViewIntegerTextfield;

public class SettingInteger
extends Setting<Integer> {
    private Float max;
    private Float min;
    private String suffix;

    public SettingInteger max(float value) {
        this.max = Float.valueOf(value);
        return this;
    }

    public SettingInteger min(float value) {
        this.min = Float.valueOf(value);
        return this;
    }

    public SettingInteger slider(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public String handleSave() {
        return ((Integer)this.value).toString();
    }

    @Override
    public boolean handleParse(String value) {
        try {
            Integer val = Integer.valueOf(value);
            if (this.max != null && (float)val.intValue() > this.max.floatValue()) {
                return false;
            }
            if (this.min != null && (float)val.intValue() < this.min.floatValue()) {
                return false;
            }
            this.value = val;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Float getMin() {
        return this.min;
    }

    public Float getMax() {
        return this.max;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public <X extends Setting<Integer>> SettingView<X> getView(Module mod) {
        if (this.suffix != null && this.min != null && this.max != null) {
            return new SettingViewIntegerSlider(this, mod);
        }
        return new SettingViewIntegerTextfield(this, mod);
    }
}

