/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.util.Arrays;

public class ColorConverter {
    private final Color[] colors;
    private final IndexColorModel colorModel;

    public ColorConverter(int ... colors) {
        this((Color[])Arrays.stream(colors).mapToObj(i -> new Color(i | 0xFF000000)).toArray(Color[]::new));
    }

    public ColorConverter(Color ... colors) {
        this.colors = colors;
        this.colorModel = ColorConverter.createColorModel(colors);
    }

    private static IndexColorModel createColorModel(Color[] colors) {
        int[] cmap = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            cmap[i] = colors[i].getRGB();
        }
        int bits = (int)Math.ceil(Math.log(cmap.length) / Math.log(2.0));
        return new IndexColorModel(bits, cmap.length, cmap, 0, false, -1, 0);
    }

    public int nearestIndex(Color color) {
        return ((byte[])this.colorModel.getDataElements(color.getRGB(), null))[0];
    }

    public Color nearestColor(Color color) {
        return this.colors[this.nearestIndex(color)];
    }
}

