/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static ImageUtil instance;

    private ImageUtil() {
    }

    public static ImageUtil getInstance() {
        if (instance == null) {
            instance = new ImageUtil();
        }
        return instance;
    }

    public Optional<BufferedImage> loadImage(String file) {
        try {
            return Optional.of(ImageIO.read(new File(file)));
        }
        catch (Exception exception) {
            try {
                return Optional.of(ImageIO.read(new URL(file)));
            }
            catch (Exception exception2) {
                try {
                    return Optional.of(ImageIO.read(this.getClass().getResourceAsStream(file)));
                }
                catch (Exception exception3) {
                    return Optional.empty();
                }
            }
        }
    }

    public BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 2);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }
}

