/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.whiletrue.toolsmod.util.PlayerProfile;
import de.whiletrue.toolsmod.util.classes.JavaUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class MojangUtils {
    private static MojangUtils instance;

    private MojangUtils() {
    }

    public static MojangUtils getInstance() {
        if (instance == null) {
            instance = new MojangUtils();
        }
        return instance;
    }

    public Optional<PlayerProfile> getPlayerProfile(String username) {
        try {
            JsonObject data = new JsonParser().parse((Reader)new InputStreamReader(new URL("https://api.mojang.com/users/profiles/minecraft/" + username).openStream())).getAsJsonObject();
            String name = data.get("name").getAsString();
            String uuid = data.get("id").getAsString();
            JsonArray allNames = new JsonParser().parse((Reader)new InputStreamReader(new URL("https://api.mojang.com/user/profiles/" + uuid + "/names").openStream())).getAsJsonArray();
            List<PlayerProfile.Name> previousNames = Streams.stream((Iterable)allNames).map(i -> {
                JsonObject obj = i.getAsJsonObject();
                return new PlayerProfile.Name(obj.get("name").getAsString(), obj.has("changedToAt") ? obj.get("changedToAt").getAsLong() : -1L);
            }).collect(Collectors.toList());
            return Optional.of(new PlayerProfile(name, uuid, previousNames));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public String getAuthToken(String email, String password) throws IOException, Exception {
        HttpPost www = new HttpPost("https://authserver.mojang.com/authenticate");
        www.addHeader("Content-Type", "application/json");
        JsonObject dataObject = new JsonObject();
        JsonObject agent = new JsonObject();
        agent.addProperty("name", "Minecraft");
        agent.addProperty("version", (Number)1);
        dataObject.add("agent", (JsonElement)agent);
        dataObject.addProperty("username", email);
        dataObject.addProperty("password", password);
        StringEntity ent = new StringEntity(dataObject.toString());
        www.setEntity((HttpEntity)ent);
        CloseableHttpResponse client = HttpClientBuilder.create().build().execute((HttpUriRequest)www);
        JsonObject resp = new JsonParser().parse(JavaUtil.getInstance().convertInputStreamToString(client.getEntity().getContent())).getAsJsonObject();
        if (resp.has("error")) {
            throw new Exception(resp.get("error").getAsString());
        }
        return resp.get("accessToken").getAsString();
    }

    public boolean login(String username, String password) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(String username) {
        try {
            Field f = Session.class.getField("username");
            f.set(Minecraft.func_71410_x().func_110432_I(), username);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

